(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     63118,       1787]*)
(*NotebookOutlinePosition[     64681,       1832]*)
(*  CellTagsIndexPosition[     64637,       1828]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["\<\
N\[UAcute]meros complejos, visualizaci\[OAcute]n de funciones complejas, \
fractales, sucesiones de potencias complejas.\
\>", "Title"],

Cell[TextData[StyleBox[
"F. Javier P\[EAcute]rez Gonz\[AAcute]lez \nDepartamento de An\[AAcute]lisis \
Matem\[AAcute]tico\nUniversidad de Granada",
  FontSize->12]], "Author",
  TextAlignment->Right],

Cell[CellGroupData[{

Cell["Descripci\[OAcute]n de la pr\[AAcute]ctica", "Section"],

Cell[TextData[{
  "Esta pr\[AAcute]ctica consta de cuatro partes. En la primera se introducen \
algunos comandos b\[AAcute]sicos de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " para trabajar con n\[UAcute]meros complejos. Comprobar\[AAcute]s que el \
conocimiento de las funciones elementales complejas, en particular los \
logaritmos y las potencias complejas, es importante para entender algunas \
respuestas de ",
  StyleBox["Mathematica.",
    FontSlant->"Italic"],
  " En la segunda parte se introducen comandos espec\[IAcute]ficos para \
representar gr\[AAcute]ficamente funciones complejas. En la tercera se \
representan algunos conjuntos fractales y termina esta pr\[AAcute]ctica \
estudiando sucesiones de potencias complejas. Tu trabajo consiste en leer y \
entender lo que sigue y realizar los ejercicios que te propongo. "
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Aritm\[EAcute]tica. Forma polar. Ra\[IAcute]ces, logaritmos y potencias \
complejas.\
\>", "Section"],

Cell[TextData[{
  "Empezaremos aprendiendo algunos comandos espec\[IAcute]ficos que tiene ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " para trabajar con n\[UAcute]meros complejos. En ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " la letra I may\[UAcute]scula representa la unidad imaginaria. No olvides \
dejar un espacio libre al escribirla. Tambi\[EAcute]n puedes escribir la \
unidad imaginaria tecleando \"\[EscapeKey] ii \[EscapeKey]\"."
}], "Text"],

Cell[BoxData[{
    RowBox[{
      StyleBox[\(z = \(-5\) + I\ 4\),
        "Input"], 
      StyleBox[";",
        "Input"], "\n", 
      StyleBox[\(Re[z]\),
        "Input"]}], 
    StyleBox[\(Im[z]\),
      "Input"], 
    StyleBox[\(Abs[z]\),
      "Input"], \(Arg[z]\), \(Conjugate[z]\), 
    StyleBox[\(Clear[z]\),
      "Input"]}], "Input"],

Cell["\<\
Como ves \"Re[ ]\" e \"Im[ ]\" dan la parte real e imaginaria, \"Abs[ ]\" nos \
da el m\[OAcute]dulo, \"Arg[ ]\" es el argumento principal y \"Conjugate[ ]\" \
es el conjugado. \
\>", "Text",
  TextJustification->1],

Cell[TextData[{
  "Te recuerdo que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "  trabaja  con n\[UAcute]meros complejos por defecto, por eso cuando una \
expresi\[OAcute]n contenga variables no debes olvidar que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " las tratar\[AAcute] como n\[UAcute]meros complejos.  Por ejemplo, no \
debes pensar que Re[a + i b] debe ser a, puesto que ello s\[OAcute]lo es as\
\[IAcute] cuando a y b son n\[UAcute]meros reales."
}], "Text"],

Cell[BoxData[{
    \(Re[a + I\ b]\), 
    \(Conjugate[a\  + \ I\ b]\), 
    \(Re[\((a + \ I\ b)\) \((c\  + \ I\ d)\)]\)}], "Input"],

Cell[TextData[{
  "Podemos decirle a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que ciertas variables son reales con la orden",
  StyleBox[" ",
    FontFamily->"Times New Roman"],
  StyleBox["\"",
    FontFamily->"Times New Roman",
    FontSize->10],
  StyleBox["ComplexExpand[expr]\" ",
    FontFamily->"Times New Roman"],
  "que desarrolla ",
  StyleBox["\"",
    FontFamily->"Times New Roman",
    FontSize->10],
  StyleBox["expr", "TI",
    FontFamily->"Times New Roman",
    FontSlant->"Plain"],
  StyleBox["\"", "TI",
    FontFamily->"Times New Roman",
    FontSize->9,
    FontSlant->"Plain"],
  StyleBox[" ",
    FontFamily->"Times New Roman",
    FontSize->14],
  "suponiendo que todas las variables que figuran en la misma son reales."
}], "Text"],

Cell[BoxData[{
    RowBox[{
      StyleBox[
        RowBox[{"C", 
          StyleBox["omplexExpand",
            "Input"]}]], 
      StyleBox["[",
        "Input"], 
      StyleBox[\(Re[a + I\ b]\),
        "Input"], 
      StyleBox["]",
        "Input"]}], "\n", \(ComplexExpand[
      Re[\((a + \ I\ b)\) \((c\  + \ I\ d)\)]]\), "\n", \(\(Conjugate[
        a\  + \ I\ b]\)\(//\)\(ComplexExpand\)\(\ \)\( (*\ 
        esta\ es\ una\ forma\ usual\ de\ escribir\ algunos\ comandos\ de\ \
Mathematica\ *) \)\)}], "Input"],

Cell[TextData[{
  "Para que te convenzas de que Arg[z] es el argumento principal de z, \
observa en la siguiente gr\[AAcute]fica la disontinuidad del argumento en ",
  Cell[BoxData[
      \(TraditionalForm\`t = \[Pi]\)]],
  " y en ",
  Cell[BoxData[
      \(TraditionalForm\`t = \(-\[Pi]\)\)]],
  " puntos en los que salta de \[Pi] a -\[Pi] ."
}], "Text"],

Cell[BoxData[
    \(\(\(\(graf = 
        Plot[Arg[Cos[t] + \ I\ Sin[t]], {t, \(-3\) \[Pi], 3  \[Pi]}, 
          Ticks -> {\[Pi]\ Range[\(-3\), 3], {\(-\[Pi]\), \[Pi]}}, 
          AspectRatio \[Rule] Automatic, DisplayFunction -> Identity];\)\n
    \(\(\(Show[
          graf /. {Line[x_]} -> {Line[
                  Select[graf[\([1, 1, 1, 
                        1]\)], \((Abs[#[\([1]\)] + 
                              N[2  \[Pi]] - #[\([2]\)]] <  .01)\) &]], 
                Line[Select[
                    graf[\([1, 1, 1, 
                        1]\)], \((Abs[#[\([1]\)] - #[\([2]\)]] <  .01)\) &]], 
                Line[Select[
                    graf[\([1, 1, 1, 
                        1]\)], \((Abs[#[\([1]\)] - 
                              N[2  \[Pi]] - #[\([2]\)]] <  .01)\) &]]}, 
          DisplayFunction -> $DisplayFunction, 
          ImageSize \[Rule] {402.625, 134}]\) \);\)\)\( (*\ 
      como\ la\ gr\[AAcute]fica\ tiene\ discontinuidades\ de\ salto\ he\ \
hecho\ un\ arreglito\ para\ que\ Mathematica\ no\ las\ una\ por\ segmentos\ \
verticales\ *) \)\)\)], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " tiene otra funci\[OAcute]n que hace lo mismo que la funci\[OAcute]n Arg[ \
], es la funci\[OAcute]n ArcTan[x,y] que proporciona el argumento principal \
del n\[UAcute]mero complejo x + I y. Por tanto, las funciones ",
  Cell[BoxData[
      \(TraditionalForm\`ArcTan[Cos[t], Sin[t]]\)]],
  " y Arg[Cos[t] + I Sin[t]]  son la misma. Podemos comprobarlo \
gr\[AAcute]ficamente."
}], "Text"],

Cell[BoxData[
    \(\(\(Clear[graf]\[IndentingNewLine]
    \(graf = 
        Plot[ArcTan[Cos[y], Sin[y]], {y, \(-3\) \[Pi], 3  \[Pi]}, 
          Ticks -> {\[Pi]*Range[\(-3\), 3], {\(-\[Pi]\), \[Pi]}}, 
          AspectRatio \[Rule] Automatic, DisplayFunction -> Identity];\)\n
    \(\(\(Show[
          graf /. {Line[x_]} -> {Line[
                  Select[graf[\([1, 1, 1, 
                        1]\)], \((Abs[#[\([1]\)] + 
                              N[2  \[Pi]] - #[\([2]\)]] <  .01)\) &]], 
                Line[Select[
                    graf[\([1, 1, 1, 
                        1]\)], \((Abs[#[\([1]\)] - #[\([2]\)]] <  .01)\) &]], 
                Line[Select[
                    graf[\([1, 1, 1, 
                        1]\)], \((Abs[#[\([1]\)] - 
                              N[2  \[Pi]] - #[\([2]\)]] <  .01)\) &]]}, 
          DisplayFunction -> $DisplayFunction, 
          ImageSize \[Rule] {402.625, 134}]\) \);\)\)\( (*\ 
      es\ la\ misma\ gr\[AAcute]fica\ anterior\ *) \)\)\)], "Input"],

Cell[TextData[{
  "Observa que  ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(ArcTan[Cos[t], Sin[t]]\)\(=\)\(t\)\(\ \)\)\)]],
  "solamente cuando ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Pi]\) < t \[LessEqual] \[Pi]\)]],
  "."
}], "Text"],

Cell["\<\
No hay ninguna novedad en lo referente a la multiplicaci\[OAcute]n y a la \
divisi\[OAcute]n de n\[UAcute]meros complejos: se hacen de la forma usual. \
Para obtener el resultado en forma cartesiana hay que usar a  veces \
\"ComplexEx\[AGrave]nd[ ]\".\
\>", "Text"],

Cell[BoxData[{
    \(\(3 + 4\ I\)\/\(5 - 2\ I\)\), "\[IndentingNewLine]", 
    \(\@\(\(2 - 3\ I\)\/\(3 + 5  I\)\)\), "\[IndentingNewLine]", 
    \(\@\(\(2 - 3\ I\)\/\(3 + 5  I\)\) // ComplexExpand\)}], "Input"],

Cell[TextData[{
  "Tambi\[EAcute]n se hacen de la forma usual las potencias. Mererece la pena \
detenerse en las potencias de exponente racional y complejo para entender c\
\[OAcute]mo trabaja ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " con ellas. Vamos a considerar las ra\[IAcute]ces de un n\[UAcute]mero \
complejo. Ya sabes que todo n\[UAcute]mero complejo distinto de cero tiene n \
ra\[IAcute]ces n-\[EAcute]simas distintas. \[DownQuestion]Cu\[AAcute]l de \
ellas es la que se representa en ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " por z^(1/n) o, lo que es igual, por ",
  Cell[BoxData[
      \(TraditionalForm\`\@z\%n\)]],
  "? Para saberlo podemos usar ComplexExpand."
}], "Text"],

Cell[BoxData[
    \(ComplexExpand[\((x\  + \ I\ y)\)^{1/3}]\)], "Input"],

Cell[TextData[{
  "Es decir, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " proporciona siempre el ",
  StyleBox["valor principal",
    FontSlant->"Italic"],
  " de la ra\[IAcute]z. Ahora puedes comprender por qu\[EAcute] si le pides a \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que calcule ",
  Cell[BoxData[
      \(TraditionalForm\`\@\(x\^3\)\%3\)]],
  "la respuesta no puede ser ",
  StyleBox["x",
    FontSlant->"Italic"],
  ". F\[IAcute]jate que si ",
  StyleBox["x",
    FontSlant->"Italic"],
  " es real entonces s\[IAcute] es cierto que ",
  StyleBox["x ",
    FontSlant->"Italic"],
  "es la \[UAcute]nica ra\[IAcute]z c\[UAcute]bica ",
  StyleBox["real",
    FontSlant->"Italic"],
  " de ",
  Cell[BoxData[
      \(TraditionalForm\`x\^3\)]],
  ", pero ",
  StyleBox["Mathematica,",
    FontSlant->"Italic"],
  " por defecto, trata ",
  StyleBox["x",
    FontSlant->"Italic"],
  " como un n\[UAcute]mero complejo y hay ",
  StyleBox["tres",
    FontSlant->"Italic"],
  " complejos distintos que tienen igual cubo. Por eso la igualdad ",
  Cell[BoxData[
      \(TraditionalForm\`\@\(z\^3\)\%3 = z\)]],
  " no es cierta en general. Ya debes saber que dicha igualdad se verificar\
\[AAcute] solamente cuando -\[Pi]/3<Arg[z]\[LessEqual]\[Pi]/3. \
Tambi\[EAcute]n puedes entender por qu\[EAcute] si pides a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que calcule ",
  Cell[BoxData[
      \(TraditionalForm\`\(\@z\) \@w\)]],
  " la respuesta no puede ser ",
  Cell[BoxData[
      \(TraditionalForm\`\@\(z\ w\)\)]],
  "."
}], "Text"],

Cell[BoxData[{
    \(\@\(z\^3\)\%\(\(3\)\(\ \)\)\), "\n", 
    \(\(\@z\) \@w\)}], "Input"],

Cell[TextData[{
  StyleBox["Nota importante",
    FontWeight->"Bold"],
  ". Esta pr\[AAcute]ctica la prepar\[EAcute] con la versi\[OAcute]n 5.0 de \
",
  StyleBox["Mathematica. ",
    FontSlant->"Italic"],
  "Al probarla con la versi\[OAcute]n 3.0 he comprobado que el comando \
\"Simplify\" que en la versi\[OAcute]n 5.0 y en la 4.1 admite ser usado de la \
forma \"Simplify[expr,condiciones]\" no puede ser usado con \"condiciones\" \
en la versi\[OAcute]n 3.0. Por ello, en lo que sigue, hay algunas celdas que \
ya est\[AAcute]n ejecutadas usando la versi\[OAcute]n 5.0 y no debes volver a \
ejecutarlas en clase de pr\[AAcute]cticas porque ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "3.0 que es la versi\[OAcute]n de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que est\[AAcute] instalada en los ordenadores de la Escuela te dar\
\[AAcute] un mensaje de error y perder\[AAcute]s la informaci\[OAcute]n."
}], "Text"],

Cell[BoxData[
    \(\(\( (*\ 
      no\ eval\[UAcute]es\ esta\ celda\ *) \)\(\n\)\(Simplify[\@\(z\^3\)\%3\ \
, \(-\[Pi]\)/3 < Arg[z] \[LessEqual] \ \[Pi]/3]\)\(\ \)\)\)], "Input"],

Cell[BoxData[
    \(\(\( (*\ 
      no\ eval\[UAcute]es\ esta\ celda\ *) \)\(\n\)\(Simplify[\@\(z\^3\)\%3\ \
, \(-\[Pi]\)/3 \[LessEqual] \ 
        Arg[z] \[LessEqual] \ \[Pi]/
          3]\)\(\ \)\( (*\ \(Una\ peque\[NTilde]a\ diferencia\ con\ la\ \
anterior\ pero ... \)\ \[DownExclamation]las\ matem\[AAcute]ticas\ son\ \
\(exactas!\)\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(\(\(\(ComplexExpand[\@\(I\^3\)\%3]\)\(\ \ \ \)\)\( (*\ 
      en\ general\ no\ es\ cierto\ que\ \@\(z\^3\)\%3\ sea\ igual\ a\ z\ *) \
\)\)\)], "Input"],

Cell[BoxData[
    \(\(\(ComplexExpand[\@\(-1\)\%3]\)\(\ \)\( (*\ \(-1\)\ es\ tratado\ como\ \
n\[UAcute]mero\ complejo\ y\ Mathematica\ proporciona\ siempre\ el\ valor\ \
principal\ de\ la\ ra\[IAcute]z\ *) \)\)\)], "Input"],

Cell[BoxData[{
    \(\(\@\(-I\)\) \@\(-I\)\ \ \ \ \ \ \ \  (*\ 
      en\ general\ no\ es\ cierto\ que\ \(\@z\) \@w\ sea\ igual\ a\ 
        \@\(z*w\)\ *) \), 
    \(\@\(\((\(-I\))\)*\((\(-I\))\)\)\)}], "Input"],

Cell[TextData[{
  "Ya ves que saber un poquito de n\[UAcute]meros complejos ayuda a entender \
lo que hace ",
  StyleBox["Mathematica.",
    FontSlant->"Italic"],
  " Para obtener todas las ra\[IAcute]ces de orden n de un n\[UAcute]mero \
complejo puedes usar el comando \"Solve\". "
}], "Text"],

Cell[TextData[{
  "Veamos c\[OAcute]mo trabaja ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " con los logaritmos complejos."
}], "Text"],

Cell[BoxData[
    \(ComplexExpand[Log[x\  + \ I\ y]]\)], "Input"],

Cell[TextData[{
  "Es decir, la funci\[OAcute]n Log[z] nos da el ",
  StyleBox["valor principal ",
    FontSlant->"Italic"],
  "del logaritmo de z. Ahora puedes entender la siguiente respuesta de ",
  StyleBox["Mathematica.",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[{
    \(Exp[Log[z]]\), 
    \(Log[Exp[z]]\ \  (*\ 
      en\ general\ no\ es\ verdad\ que\ Log[Exp[z]]\ sea\ igual\ a\ z\ *) 
      \), 
    \(Log[Exp[7\ I]]\  (*\ aqu\[IAcute]\ tienes\ un\ ejemplo\ *) \)}], "Input"],

Cell["Veamos lo que vale Log[Exp[z]].", "Text"],

Cell[BoxData[
    \(ComplexExpand[Log[Exp[x\  + \ I\ y]]]\)], "Input"],

Cell[TextData[{
  "Ya has visto antes que no siempre es cierto que ArcTan[Cos[y],Sin[y]] sea \
igual a y. De hecho la igualdad ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(ArcTan[Cos[y], 
          Sin[y]]\)\(=\)\(y\)\(\ \ \)\)\)]],
  "es cierta solamente cuando ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Pi]\) < y \[LessEqual] \[Pi]\)]],
  ". Por tanto, la igualdad ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(Log[Exp[x\  + \ I\ y]] = 
        x\  + \ I\ y\)\)\)]],
  " es cierta solamente cuando ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Pi]\) < y \[LessEqual] \[Pi]\)]],
  "."
}], "Text"],

Cell[BoxData[{
    \(ComplexExpand[Log[\(-1\) + I\ \@3] + Log[\(-\@3\) + I]]\  (*\ 
      en\ general\ no\ es\ verdad\ que\ Log[z]\  + \ 
        Log[w]\ sea\ igua\ a\ Log[z*w]\ pues\ pueden\ diferenciarse\ en\ un\ 
          m\[UAcute]ltiplo\ entero\ de\ 2  \[Pi]I\ *) \), 
    \(ComplexExpand[Log[\((\(-1\) + I\ \@3)\) \((\(-\@3\) + I)\)]]\)}], 
  "Input"],

Cell["\<\
Consideremos a continuaci\[OAcute]n las potencias de base y exponente \
complejos.\
\>", "Text"],

Cell[BoxData[
    \(ComplexExpand[\((a\  + \ I\ b)\)^\((c\  + \ I\ d)\)]\)], "Input"],

Cell[TextData[{
  "Parece demasiado complicado. Recordemos la definici\[OAcute]n del valor \
principal de la potencia ",
  Cell[BoxData[
      \(TraditionalForm\`\((a\  + \ I\ b)\)\^\((c\  + \ I\ d)\) = \
\(\(Exp[\((c\  + \ I\ d)\) Log[a\  + \ I\ b]]\)\(.\)\)\)]]
}], "Text"],

Cell[BoxData[
    \(ComplexExpand[Exp[\((c\  + \ I\ d)\) Log[a\  + \ I\ b]]]\)], "Input"],

Cell[TextData[{
  "Est\[AAcute] claro que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " calcula el",
  StyleBox[" valor principal",
    FontSlant->"Italic"],
  " de la potencia."
}], "Text"],

Cell[BoxData[{
    \(ComplexExpand[\((\((\(-I\))\)*\((\(-I\))\))\)^I]\ \  (*\ 
      en\ general\ no\ es\ cierto\ que\ \((u*v)\)\^z\ sea\ igual\ a\ u\^z*
        v\^z\ *) \), "\n", 
    \(ComplexExpand[\((\(-I\))\)^I\ *\((\(-\ I\))\)^I]\)}], "Input"],

Cell[BoxData[
    \(Clear["\<Global`*\>"]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Visualizaci\[OAcute]n de funciones complejas", "Section"],

Cell[TextData[{
  "Cualquier funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm
      \`f\  : \ \[DoubleStruckCapitalC] \[Rule] \[DoubleStruckCapitalC]\)]],
  "  podemos verla como una funci\[OAcute]n de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  " en  ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  " y  por tanto para su representaci\[OAcute]n necesitariamos \
gr\[AAcute]ficos en cuatro dimensiones. Lo que podemos hacer para visualizar \
su comportamiento es representar c\[OAcute]mo se transforma una familia de \
curvas como, por ejemplo, rectas paralelas a los ejes o circunferencias \
centradas en el origen. "
}], "Text",
  TextJustification->1],

Cell[TextData[{
  "Veamos un ejemplo de esto. Vamos a considerar la familia ",
  StyleBox["circunferencias",
    FontSlant->"Italic"],
  " formada por nueve circunferencias centradas en el origen y de radios r \
desde 0.1 hasta 1 (cada una en el color Hue[r]). Haremos actuar sobre dichas \
circunferencias la funci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        FormBox[
          RowBox[{\(f(z)\), "=", 
            FormBox[\(\(1 - z\)\/\(1 + z\)\),
              "TraditionalForm"]}],
          "TraditionalForm"], TraditionalForm]]],
  " y obtendremos la familia ",
  StyleBox["imagencircunferencias",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[BoxData[{
    \(\(Clear[f, z, circunferencias, imagencircunferencias];\)\), "\n", 
    \(\(f[z_] := \((1 - z)\)/\((1 + z)\);\)\), "\n", 
    \(\(\(circunferencias = 
        ParametricPlot[
          Evaluate[
            Table[r {Cos[t], \ Sin[t]}, \ {r, \  .1, \ 1, \  .1}]], \ {t, 0, 
            2\ Pi}, \ \n\t\tPlotStyle -> 
            Table[Hue[r], \ {r, \  .1, 1,  .1}], \n\t\tAspectRatio -> 
            1, \n\t\tAxesLabel -> {"\<x\>", "\<y\>"}, \n\t\tFrame -> 
            True, \t\n\t\tDisplayFunction -> Identity];\)\(\n\)
    \)\t\t\), "\n", 
    \(\(\(imagencircunferencias = 
        ParametricPlot[\n\t\tEvaluate[
            Table[{Re[f[r\ Cos[t] + I\ r\ \ Sin[t]]], \ 
                Im[f[r\ Cos[t] + I\ r\ \ Sin[t]]]}, \ {r, \  .1, \ 
                1, \  .1}]], \ {t, 0, 2\ Pi}, \ \n\t\tPlotStyle -> 
            Table[Hue[r], \ {r, \  .1, 1,  .1}], \n\t\tPlotRange -> {{0, 
                6}, {\(-3\), 3}}, \n\t\tAspectRatio -> 
            1, \n\t\tAxesLabel -> {"\<u\>", "\<v\>"}, \n\t\tFrame -> 
            True, \n\t\tDisplayFunction -> Identity];\)\(\n\)
    \)\t\t\), "\n", 
    \(Print["\<Familia de circunferencias C(0,r); r=0.1-1\>"]; 
    Show[{circunferencias}, \ 
      DisplayFunction -> $DisplayFunction];\n\), "\n", 
    \(\(Print["\<Imagen por f(z)=\>", 
        f[z], \ "\<de la familia de circunferencias C(0,r); r=0.1-1\>"];\)\), \
"\n", 
    \(\(Show[{imagencircunferencias}, \ 
        DisplayFunction -> $DisplayFunction];\)\), "\[IndentingNewLine]", 
    \(\(Clear[f, z, circunferencias, imagencircunferencias];\)\)}], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " posee un comando que nos permite ver la imagen de una familia de rectas \
paralelas a los ejes mediante una funci\[OAcute]n compleja. Para ello es \
necesario cargar el paquete ComplexMap. "
}], "Text"],

Cell[BoxData[
    \(<< Graphics`ComplexMap`\)], "Input"],

Cell["\<\
Tambi\[EAcute]n es conveniente cargar el siguiente paquete para trabajar con \
comodidad con colores.\
\>", "Text"],

Cell[BoxData[
    \(\(\(\(Needs["\<Graphics`Colors`\>"]\) \)\(;\)\(\ \ \)\( (*para\ usar\ \
colores\ con\ comodidad*) \)\(\n\)\(\(Off[
        General::spell1]\) \)\(;\)\(\ \ \)\(\n\)\( (*para\ que\ Mathematica\ \
no\ nos\ moleste\ con\ avisos\ de\ error\ en\ los\ nombres\ de\ los\ comandos*) \
\)\)\)], "Input"],

Cell[BoxData[
    \(\(?\ CartesianMap\)\)], "Input"],

Cell["\<\
Utilizando este comando puedes ver c\[OAcute]mo una determinada \
funci\[OAcute]n act\[UAcute]a sobre una regi\[OAcute]n del plano y adem\
\[AAcute]s c\[OAcute]mo transforma los segmentos verticales y los \
horizontales. Aqu\[IAcute] tienes un bonito ejemplo con la aplicaci\[OAcute]n \
f(z)=1/z.\
\>", "Text"],

Cell[BoxData[{
    \(\(f[z_] = 1/z;\)\), "\n", 
    \(\(CartesianMap[
        Identity, \ {0.5, 10, 0.5}, {\(-5\), 5, 
          0.5}, \[IndentingNewLine]Ticks \[Rule] {Range[0, 10, 2], 
            Range[\(-5\), 5, 1]}, AxesLabel \[Rule] {"\<x\>", "\<y\>"}, 
        PlotStyle \[Rule] {Blue, Red}];\)\), "\n", 
    \(\(Print["\<El semiplano Re[z] > 1/2\>"];\)\), "\n", 
    \(\(CartesianMap[
        f, \ {0.5, 10, 0.5}, {\(-5\), 5, 
          0.5}, \[IndentingNewLine]PlotRange \[Rule] {{\(-0.1\), 
              2.1}, {\(-1.1\), 1.1}}, \[IndentingNewLine]AspectRatio \[Rule] 
          1, Ticks \[Rule] {Range[0, 2, 1], Range[\(-2\), 2, 1]}, 
        AxesLabel \[Rule] {"\<u\>", "\<v\>"}, 
        PlotStyle \[Rule] {Blue, Red}];\)\), "\n", 
    \(\(Print["\<Su imagen por f(z)=1/z es el disco |w - 1| < 1\>"];\)\), "\n\
", 
    \(Clear[f]\)}], "Input",
  AspectRatioFixed->True],

Cell["Teniendo en cuenta que:", "Text"],

Cell[BoxData[
    \(ComplexExpand[Exp[x\  + \ I\ y]]\)], "Input"],

Cell[TextData[{
  "Es evidente que la imagen por la funci\[OAcute]n exponencial de una recta \
vertical (x constante) es una circunferencia centrada en el origen de radio \
",
  Cell[BoxData[
      \(TraditionalForm\`e\^x\)]],
  ", y la imagen de una recta horizontal (",
  StyleBox["y",
    FontSlant->"Italic"],
  " constante) es una semirecta con extremo en el origen y vector de direcci\
\[OAcute]n (Cos[y],Sin[y])."
}], "Text"],

Cell[TextData[
"Aqu\[IAcute] puedes ver c\[OAcute]mo la funci\[OAcute]n exponencial \
transforma rect\[AAcute]ngulos en sectores de corona circular. Utiliza los \
controles para ver despacio la animaci\[OAcute]n. Observa c\[OAcute]mo la \
imagen de la funci\[OAcute]n exponencial va cambiando. Mantenemos fijo el \
intervalo de abscisas (la anchura del rect\[AAcute]ngulo) [-1,1] (del cual \
depende el m\[OAcute]dulo de la imagen) y vamos aumentando el intervalo de \
ordenadas (la altura del rect\[AAcute]ngulo) desde [-\[Pi]/10, \[Pi]/10] \
hasta [-\[Pi], \[Pi]] (del que dependen los argumentos de la imagen)."], 
  "Text"],

Cell[BoxData[{
    \(\(Do[
        Show[GraphicsArray[{CartesianMap[
                Identity, \ {\(-1\), 1, 0.1}, {\(-k\)\ \[Pi], k\ \[Pi], 0.1}, 
                AxesLabel \[Rule] {"\<x\>", "\<y\>"}, 
                PlotStyle \[Rule] {Red, Blue}, Ticks \[Rule] None, 
                PlotRange \[Rule] {{\(-3\), 3}, {\(-3\), 3}}, 
                ImageSize \[Rule] {356, 170}, 
                DisplayFunction \[Rule] Identity], 
              CartesianMap[
                Exp, \ {\(-1\), 1, 0.1}, {\(-k\)\ \[Pi], k\ \[Pi], 
                  0.1}, \[IndentingNewLine]AxesLabel \[Rule] {"\<u\>", \
"\<v\>"}, PlotStyle \[Rule] {Red, Blue}, Ticks \[Rule] None, 
                PlotRange \[Rule] {{\(-3\), 3}, {\(-3\), 3}}, 
                ImageSize \[Rule] {356, 170}, 
                DisplayFunction \[Rule] Identity]}]], {k,  .1, 
          1,  .2}];\)\), "\n", 
    \(\(SelectionMove[EvaluationNotebook[], All, GeneratedCell];\)\), "\n", 
    \(FrontEndTokenExecute["\<CellGroup\>"]\), "\n", 
    \(FrontEndTokenExecute["\<OpenCloseGroup\>"]\)}], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " posee un comando que nos permite ver la imagen por una funci\[OAcute]n \
compleja de una familia de rectas que pasan por el origen y de una familia de \
circunferencias centradas en el origen."
}], "Text"],

Cell[BoxData[
    \(\(?PolarMap\)\)], "Input"],

Cell[BoxData[
    \(\(PolarMap[Identity, \ {0, 1}, {\(-Pi\)\ , \ Pi}, 
        PlotStyle -> {Red, Blue}];\)\)], "Input"],

Cell[TextData[{
  "Aqu\[IAcute] tienes la imagen por la funci\[OAcute]n logaritmo de la \
corona circular {z \[Epsilon] ",
  StyleBox["\[DoubleStruckC] ",
    FontSize->16],
  Cell[BoxData[
      \(TraditionalForm\`\( : \(e\^\(-3\) < \) | z | \( < e\)\^3\)\)]],
  "} . Observa c\[OAcute]mo los radios se convierten en segmentos \
horizontales y las circunferencias en segmentos verticales."
}], "Text"],

Cell[BoxData[
    \(\(Show[
        GraphicsArray[{{PolarMap[
                Identity, {E^\(-3\), 
                  E^3, \((E^3 - E^\(-3\))\)* .1}, {\(-Pi\), Pi, 2  Pi/10}, 
                PlotStyle \[Rule] {Red, Blue}, 
                DisplayFunction \[Rule] 
                  Identity], \[IndentingNewLine]PolarMap[
                Log, {E^\(-3\), E^3, \((E^3 - E^\(-3\))\)* .1}, {\(-Pi\), Pi, 
                  2  Pi/10}, PlotStyle \[Rule] {Red, Blue}, 
                PlotRange \[Rule] {{\(-3.1\), 3.1}, {\(-3.6\), 3.6}}, 
                DisplayFunction \[Rule] Identity]}}], 
        ImageSize \[Rule] {430, 204.625}];\)\)], "Input"],

Cell[CellGroupData[{

Cell[TextData[{
  " ",
  StyleBox["Ejercicio 1",
    FontWeight->"Bold"]
}], "Exercise"],

Cell[TextData[{
  "Te propongo que realices un programa cuya entrada ser\[AAcute] un n\
\[UAcute]mero entero k,  \"poligonoregular[k]\", para dibujar \
pol\[IAcute]gonos regulares de cualquier n\[UAcute]mero de lados inscritos en \
la circunferencia unidad y que tambi\[EAcute]n represente las ra\[IAcute]ces \
k-\[EAcute]simas de la unidad por vectores (para dibujar vectores necesitar\
\[AAcute]s \"<<Graphics`Arrow`\"). Los pasos y las funciones de Mathematica \
que quiero que uses te los indico a continuaci\[OAcute]n. Naturalmente, hay \
formas mucho m\[AAcute]s inmediatas de hacer esto pero se trata de que uses \
ciertos recursos de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ".\n1. Usando el comando NSolve[ ], obt\[EAcute]n una lista, \"raices[k]\", \
con las ra\[IAcute]ces k-\[EAcute]simas de la unidad y ord\[EAcute]nalas por \
argumentos crecientes. Deber\[AAcute]s obtener una lista de puntos de la \
forma ",
  Cell[BoxData[
      \(TraditionalForm\`{x\_k, y\_k}\)]],
  ".\n2. Aplica de forma apropiada \"Arrow\" a los puntos de la lista \
anterior para representar las ra\[IAcute]ces por vectores \"vectores[k]\". \
Obtendr\[AAcute]s una lista con los vectores correspondientes.\n3. Salvo un \
detalle que t\[UAcute] mismo decubrir\[AAcute]s, ya s\[OAcute]lo te queda \
usar \"Show\",\"Line\", \"Circle\" con las opciones adecuadas para obtener la \
funci\[OAcute]n \"poligonoregular[k]\" que realiza las tareas deseadas. Dale \
un valor a k y comprueba que todo funciona bien."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  " ",
  StyleBox["Ejercicio 2",
    FontWeight->"Bold"]
}], "Exercise"],

Cell["\<\
Utiliza CartesianMap para obtener las im\[AAcute]genes del cuadrado [-1,1]\
\[Times][-1,1] por las funciones seno y tangente. \
\>", "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  " ",
  StyleBox["Ejercicio 3",
    FontWeight->"Bold"]
}], "Exercise"],

Cell["\<\
Haz una animaci\[OAcute]n para ver la imagen por la funci\[OAcute]n ra\
\[IAcute]z cuadrada de un sector del disco unidad, sim\[EAcute]trico respecto \
del eje de abscisas, cuya amplitud va aumentando de \[Pi]/5 a 2\[Pi] a \
incrementos de \[Pi]/5. \
\>", "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  " ",
  StyleBox["Ejercicio 4",
    FontWeight->"Bold"]
}], "Exercise"],

Cell[TextData[{
  "Representa gr\[AAcute]ficamente el disco ",
  Cell[BoxData[
      \(TraditionalForm\`D(\((1 + \[ImaginaryI])\)/2, 1/2)\)]],
  " y su imagen por la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f(z) = z\^4\)]],
  ". Elige de forma apropiada el n\[UAcute]mero de radios y de \
circunferencias que se representar\[AAcute]n."
}], "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Conjuntos fractales", "Section"],

Cell["\<\
Los medios de comunicaci\[OAcute]n, que suelen ignorar el mundo de las matem\
\[AAcute]ticas, hablan con cierta frecuencia de los conjuntos fractales. \
Estos conjuntos ya fueron estudiados a principios del siglo XX por el matem\
\[AAcute]tico franc\[EAcute]s Gaston Julia (1893 - 1978). Su fama actual se \
debe a otro matem\[AAcute]tico, tambi\[EAcute]n franc\[EAcute]s, Benoit \
Mandelbrot (1924) quien tuvo la enorme ventaja sobre su predecesor de \
disponer de la potencia de c\[AAcute]lculo de los modernos ordenadores para \
ver en pantalla lo que a Gaston Julia le llev\[OAcute] largu\[IAcute]simos c\
\[AAcute]lculos con papel y l\[AAcute]piz. Los conjuntos fractales de \
Mandelbrot y de Julia est\[AAcute]n estrechamente relacionados y su rara \
belleza ha atraido a muchos artistas del dise\[NTilde]o grafico que los han \
popularizado. Vamos a ver seguidamente que estos conjuntos, pese a su notable \
complejidad, pueden obtenerse de forma muy elemental iterando sucesiones muy \
sencillas de n\[UAcute]meros complejos.\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compilar funciones", "Section"],

Cell[TextData[{
  "Cuando definimos una funci\[OAcute]n de la forma usual en ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", por ejemplo ",
  Cell[BoxData[
      \(TraditionalForm\`f[x_] := x*\ Sin[1/x]\)]],
  ", dicha definici\[OAcute]n queda almacenada de forma que cuando le damos a \
",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " un valor particular ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " sustituye dicho valor en ",
  Cell[BoxData[
      \(TraditionalForm\`x*Sin[1/x]\)]],
  ". El valor que le damos a ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " puede ser de muy variadada naturaleza; puede ser exacto o aproximado, \
entero, real o un complejo, una expresi\[OAcute]n simb\[OAcute]lica o una \
lista... ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " debe tener en cuenta todas estas posibilidades con el consiguiente coste \
en tiempo de c\[AAcute]lculo. Recuerda que en lenguajes como C o Fortran hay \
que declarar los tipos de variables que vamos a usar en cada proceso.  En ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " tambi\[EAcute]n podemos hacer esto usando \
\"Compile[{{x,tipox},{y,tipoy},{z,tipoz},...},expr]\" que crea una \"funci\
\[OAcute]n compilada\" que contiene una sucesi\[OAcute]n de instrucciones muy \
simples escritas en un lenguaje pr\[OAcute]ximo al c\[OAcute]digo \
m\[AAcute]quina y eval\[UAcute]a \"expr\" para valores dados de los \
argumentos x,y,z,... de los cuales se especifica en cada caso su tipo. Esta \
forma de proceder es \[UAcute]til para definir funciones que deben realizar \
una gran cantidad de c\[AAcute]lculos n\[UAcute]mericos sencillos repetitivos \
o iterativos. Se trata de un procedimiento que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " usa internamente en comandos que tienen que evaluar repetidamente una \
funci\[OAcute]n en muchos valores como, por ejemplo, Plot[ ] o NIntegrate[ ]. \
Estos comandos usan la opci\[OAcute]n \"Compile\"."
}], "Text"],

Cell[TextData[{
  "\"Compile\" supone por defecto que sus argumentos son n\[UAcute]meros \
reales con precisi\[OAcute]n m\[AAcute]quina. Podemos compilar cuatro tipos \
de variables _Integer, _Real, _Complex y True ",
  StyleBox["|",
    FontWeight->"Bold"],
  " False. Aqu\[IAcute] tienes un ejemplo con una variable booleana."
}], "Text"],

Cell[BoxData[
    \(\(\(sumdifcond\)\(=\)\(Compile[{{x, 
            True | False}, {y, _Integer}, {z, _Integer}}, 
        If[x, z + y, z - y]]\)\( (*\ 
        en\ este\ c\[OAcute]digo\ x\ es\ una\ variable\ que\ puede\ tener\ el\
\ valor\ True\ o\ el\ valor\ False . \ Si\ x = 
          True\ la\ funci\[OAcute]n\ devuelve\ z + y; \ 
        si\ x = False\ devuelve\ z - y\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(sumdifcond[True, 5, 8]\)], "Input"],

Cell[TextData[{
  "Los siguientes ejemplos permiten apreciar la diferencia entre compilar o \
no una funci\[OAcute]n. El primer comando calcula la suma de Riemann de una \
funci\[OAcute]n f en un intervalo [a,b] que se divide en n partes iguales \
evaluando la funci\[OAcute]n en el punto medio de cada intervalo. El segundo \
comando hace lo mismo con la diferencia de que se compila la funci\[OAcute]n \
antes de evaluarla y tambi\[EAcute]n se compila el propio comando. Aplicamos \
estos comandos a la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`g(x) = \((1/x)\)\ \(cos(1/x)\)\)]],
  " en el intervalo [.01,1] al que dividimos en 100000 partes iguales. \
Observa la notable diferencia en los tiempos de ejecuci\[OAcute]n."
}], "Text"],

Cell[BoxData[{
    \(\(f[x_] = Cos[1/x]/x;\)\), "\[IndentingNewLine]", 
    \(\(fc = Compile[{{x, _Real}}, Cos[1/x]/x];\)\), "\[IndentingNewLine]", 
    \(\(Sriemann[a_, b_, n_] := 
        Module[{inc = N[\((b - a)\)/n]}, 
          Sum[f[a + 0.5*inc + k*inc], {k, 0, n - 1}]*
            inc];\)\), "\[IndentingNewLine]", 
    \(\(SCPriemann = 
        Compile[{{a, _Real}, {b, _Real}, {n, _Integer}}, 
          Module[{inc = N[\((b - a)\)/n]}, 
            Sum[fc[a + 0.5*inc + k*inc], {k, 0, n - 1}]*
              inc]];\)\), "\[IndentingNewLine]", 
    \(Sriemann[0.01, 1. , 100000] // Timing\), "\n", 
    \(SCPriemann[0.01, 1. , 100000] // Timing\)}], "Input"],

Cell[TextData[{
  "El uso de \"Compile\" est\[AAcute] especialmente indicado cuando hay que \
hacer operaciones repetitivas sencillas que no se prestan al manejo de \
listas. La siguiente funci\[OAcute]n calcula el primer natural n tal que la \
suma ",
  Cell[BoxData[
      \(TraditionalForm\`\(1 + 1/2 + 1/3 +  ... \) 1/n\)]],
  " es mayor que un n\[UAcute]mero positivo dado ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". Como esas sumas crecen muy lentamente hay que realizar un gran \
n\[UAcute]mero de c\[AAcute]lculos. Observa la gran diferencia entre compilar \
el c\[OAcute]digo o no hacerlo."
}], "Text"],

Cell[BoxData[
    \(\(\(primerasuma[x_] := 
      Module[{n = 1, s = 1. }, 
        While[s \[LessEqual] x, n = n + 1; s = s + N[1/n]]; n]\  (*\ 
      c\[OAcute]digo\ no\ compilado\ *) \[IndentingNewLine]
    \(\(\(CPprimerasuma = 
        Compile[{{x, _Real}}, 
          Module[{n = 1, s = 1. }, 
            While[s \[LessEqual] x, n = n + 1; s = s + N[1/n]]; 
            n]]\)\(\ \)\);\)\)\( (*\ 
      c\[OAcute]digo\ compilado\ *) \)\)\)], "Input"],

Cell[BoxData[{
    \(primerasuma[12] // Timing\), "\[IndentingNewLine]", 
    \(CPprimerasuma[12] // Timing\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Los conjuntos de Julia y de Mandelbrot", "Section"],

Cell[TextData[{
  "Los fractales m\[AAcute]s conocidos son los conjuntos de Julia y de \
Mandelbrot. Es muy f\[AAcute]cil generar dichos conjuntos usando \
n\[UAcute]meros complejos. Para cada n\[UAcute]mero complejo ",
  Cell[BoxData[
      FormBox[
        StyleBox["c",
          FontWeight->"Bold"], TraditionalForm]]],
  " definamos la funci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\(f\_c\) : \[DoubleStruckCapitalC]\[LongRightArrow]\
\[DoubleStruckCapitalC]\),
          FontWeight->"Bold"], TraditionalForm]]],
  " por ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\(f\_c\)(z) = z\^2 + c\),
          FontWeight->"Bold"], TraditionalForm]]],
  " para todo ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(z\  \[Element] \ \[DoubleStruckCapitalC]\),
          FontWeight->"Bold"], TraditionalForm]]],
  ". El",
  StyleBox[" conjunto de Julia",
    FontWeight->"Bold"],
  "  asociado al n\[UAcute]mero complejo ",
  Cell[BoxData[
      FormBox[
        StyleBox["c",
          FontWeight->"Bold"], TraditionalForm]]],
  " se define como el conjunto ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(J(c)\),
          FontWeight->"Bold"], TraditionalForm]]],
  " de los n\[UAcute]meros complejos ",
  Cell[BoxData[
      FormBox[
        StyleBox["z",
          FontWeight->"Bold"], TraditionalForm]]],
  " tales que la sucesi\[OAcute]n definida por ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(z\_0 = z, \ 
          z\_n = \(z\_\(n - 1\)\%2 + c = \(f\_c\)(z\_\(n - 1\))\)\),
          FontWeight->"Bold"], TraditionalForm]]],
  " est\[AAcute] acotada (algunos autores llaman conjunto de Julia",
  StyleBox[" a la frontera",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " de ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(J(c)\),
          FontWeight->"Bold"], TraditionalForm]]],
  "). El conjunto de Mandelbrot es el conjunto de los n\[UAcute]meros \
complejos ",
  Cell[BoxData[
      FormBox[
        StyleBox["c",
          FontWeight->"Bold"], TraditionalForm]]],
  " tales que la sucesi\[OAcute]n definida por ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(z\_0 = 0, \ 
          z\_n = \(z\_\(n - 1\)\%2 + c = \(f\_c\)(z\_\(n - 1\))\)\),
          FontWeight->"Bold"], TraditionalForm]]],
  " est\[AAcute] acotada. En otros t\[EAcute]rminos, el conjunto de \
Mandelbrot es el conjunto de los n\[UAcute]meros complejos ",
  Cell[BoxData[
      FormBox[
        StyleBox["c",
          FontWeight->"Bold"], TraditionalForm]]],
  " tales que ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(0 \[Element] J(c)\),
          FontWeight->"Bold"], TraditionalForm]]],
  ". \nPara representar la sucesi\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(z\_0 = z, \ 
          z\_n = \(z\_\(n - 1\)\%2 + c = \(f\_c\)(z\_\(n - 1\))\)\),
          FontWeight->"Bold"], TraditionalForm]]],
  " suele usarse la notaci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(z\_n = \(f\_c\%\((n)\)\)(z)\),
          FontWeight->"Bold"], TraditionalForm]]],
  ", con el convenio de que ",
  Cell[BoxData[
      \(TraditionalForm\`z\_0 = \(\(f\_c\%\((0)\)\)(z) = z\)\)],
    FontWeight->"Bold"],
  ". Esta sucesi\[OAcute]n se llama la ",
  StyleBox["\[OAcute]rbita",
    FontWeight->"Bold"],
  " de ",
  Cell[BoxData[
      FormBox[
        StyleBox["z",
          FontWeight->"Bold"], TraditionalForm]]],
  " por ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(f\_c\),
          FontWeight->"Bold"], TraditionalForm]]],
  " y sus elementos se obtienen iterando sucesivamente la funci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(f\_c\),
          FontWeight->"Bold"], TraditionalForm]]],
  " partiendo del valor inicial ",
  Cell[BoxData[
      FormBox[
        StyleBox["z",
          FontWeight->"Bold"], TraditionalForm]]],
  ". La notaci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(f\_c\%\((n)\)\),
          FontWeight->"Bold"], TraditionalForm]]],
  "representa la composici\[OAcute]n de la funci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(f\_c\),
          FontWeight->"Bold"], TraditionalForm]]],
  " consigo misma ",
  StyleBox["n",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " veces.\nEs sabido que si",
  StyleBox[" ",
    FontWeight->"Bold"],
  StyleBox["|c|\[LessEqual]2",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "  y",
  StyleBox[" z\[Element] J(c), ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "entonces",
  StyleBox[" ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "la \[OAcute]rbita de  ",
  Cell[BoxData[
      FormBox[
        StyleBox["z",
          FontWeight->"Bold"], TraditionalForm]]],
  " por ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(f\_c\),
          FontWeight->"Bold"], TraditionalForm]]],
  " est\[AAcute] contenida en el disco cerrado de centro 0 y radio 2 y, en \
particular, ",
  StyleBox["|z|\[LessEqual]2.",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " Tambi\[EAcute]n es sabido que el conjunto de Mandelbrot est\[AAcute] \
contenido en el disco cerrado de centro 0 y radio 2 y si un punto ",
  StyleBox["c",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontSlant->"Italic"],
  "est\[AAcute] en el conjunto de Mandelbrot, entonces ",
  StyleBox[" ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "la \[OAcute]rbita de  ",
  Cell[BoxData[
      FormBox[
        StyleBox["0",
          FontWeight->"Bold"], TraditionalForm]]],
  " por ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(f\_c\),
          FontWeight->"Bold"], TraditionalForm]]],
  " est\[AAcute] contenida en el disco cerrado de centro 0 y radio 2."
}], "Text"],

Cell[CellGroupData[{

Cell["Ejercicio 5", "Exercise"],

Cell[TextData[{
  "Define una funci\[OAcute]n compilada \"",
  Cell[BoxData[
      \(TraditionalForm\`Julia\)]],
  "\" de dos argumentos complejos ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(z, \ c\),
          FontWeight->"Bold"], TraditionalForm]]],
  ", que calcule t\[EAcute]rminos de la \[OAcute]rbita de ",
  Cell[BoxData[
      FormBox[
        StyleBox["z",
          FontWeight->"Bold"], TraditionalForm]]],
  " por ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(f\_c\),
          FontWeight->"Bold"], TraditionalForm]]],
  ". El proceso se detiene si se encuentra un t\[EAcute]rmino de dicha \
\[OAcute]rbita con m\[OAcute]dulo mayor que 2 y en otro caso contin\[UAcute]a \
hasta calcular el t\[EAcute]rmino 40 de la \[OAcute]rbita ",
  Cell[BoxData[
      FormBox[
        RowBox[{"(", 
          StyleBox[\(z\_40\),
            FontWeight->"Bold"], ")"}], TraditionalForm]]],
  ". L",
  StyleBox["a salida de esta funci\[OAcute]n debe ser",
    FontSlant->"Italic"],
  " ",
  StyleBox["el n\[UAcute]mero de iteraciones",
    FontSlant->"Italic"],
  " ",
  StyleBox["que realiza.",
    FontSlant->"Italic"],
  " \nUsa el comando DensityPlot",
  Cell[BoxData[
      \(TraditionalForm\`\([f(x, y), \ {x, \ xmin, \ xmax}, \ {y, \ ymin, \ 
          ymax}]\)\)]],
  " con opciones, PlotPoints\[Rule]200, ColorFunction\[Rule]Hue, \
Mesh\[Rule]False, AspectRatio\[Rule]Automatic, Frame\[Rule]False, para \
representar la funci\[OAcute]n \"Julia[x + I y,c]\" para valores de ",
  StyleBox["c",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " iguales a   ",
  Cell[BoxData[
      \(TraditionalForm\`\(-0.5\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`0.360284\  + \ 0.100376\ \[ImaginaryI]\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\(-0.122\)\  + \ 0.745\ \[ImaginaryI]\)]],
  " .\n",
  "Usando la funci\[OAcute]n \"Julia[ ]\" de forma adecuada representa gr\
\[AAcute]ficamente el conjunto de Mandelbrot.",
  "\n",
  StyleBox["Observaci\[OAcute]n",
    FontWeight->"Bold"],
  ": Si ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(z \[Element] \ J(c)\),
          FontWeight->"Bold"], TraditionalForm]]],
  " entonces ",
  Cell[BoxData[
      \(TraditionalForm\`Julia[z, c] = 40\)]],
  ". Es posible que para algunos valores \"raros\" de ",
  StyleBox["z",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " sean necesarias m\[AAcute]s de 40 iteraciones para saber si est\[AAcute]n \
o no en el conjunto de Julia, para tales valores podr\[IAcute]a ocurrir que \
",
  Cell[BoxData[
      \(TraditionalForm\`Julia[z, c] = 40\)]],
  " pero ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(z\  \[NotElement] J(c)\),
          FontWeight->"Bold"], TraditionalForm]]],
  ". El conjunto de estos valores \"raros\" es tan peque\[NTilde]o que no \
afecta realmente al aspecto final del conjunto. "
}], "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Aproximaci\[OAcute]n de ra\[IAcute]ces complejas por el m\[EAcute]todo \
de Newton", "Section"],

Cell[TextData[{
  "Como seguramente ya sabes, el m\[EAcute]todo de Newton es una \
t\[EAcute]cnica frecuentemente usada para calcular soluciones de una ecuaci\
\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(f(z) = 0\),
          FontWeight->"Bold"], TraditionalForm]]],
  ". Para ello, se elige un valor inicial ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(z\_1\),
          FontWeight->"Bold"], TraditionalForm]]],
  " y, a partir de \[EAcute]l, se forma la sucesi\[OAcute]n definida por",
  StyleBox[" ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        RowBox[{\(z\_\(n + 1\)\), "=", 
          RowBox[{\(z\_n\), "-", 
            StyleBox[\(\(f(z\_n)\)\/\(f\ ' \((z\_n)\)\)\),
              FontSize->16]}]}], TraditionalForm]],
    FontWeight->"Bold"],
  ". Si dicha sucesi\[OAcute]n converge, su l\[IAcute]mite es una soluci\
\[OAcute]n de la ",
  "ecuaci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(f(z) = 0\),
          FontWeight->"Bold"], TraditionalForm]]],
  ".",
  " Naturalmente, cuando hay m\[AAcute]s de una soluci\[OAcute]n, la elecci\
\[OAcute]n del valor inicial determina a cu\[AAcute]l de ellas converge el \
proceso. \n",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " tiene un comando \"FindRoot[f(z)=0,{z,a}]\" que utiliza precisamente el m\
\[EAcute]todo de Newton para calcular soluciones de  la ",
  "ecuaci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(f(z) = 0\),
          FontWeight->"Bold"], TraditionalForm]]],
  " a partir del valor inicial ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(z = a\),
          FontWeight->"Bold"], TraditionalForm]]],
  ". Eval\[UAcute]a la siguiente celda."
}], "Text"],

Cell[BoxData[
    \(FindRoot[z\^2 + 1 \[Equal] 0, {z, 0.5}]\)], "Input"],

Cell[TextData[{
  "\[DownQuestion]Sabes por qu\[EAcute] ha fallado el m\[EAcute]todo en este \
caso particular? F\[IAcute]jate en c\[OAcute]mo se van obteniendo las \
aproximaciones sucesivas ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(z\_\(n + 1\)\), "=", 
          RowBox[{\(z\_n\), "-", 
            StyleBox[\(\(f(z\_n)\)\/\(f\ ' \((z\_n)\)\)\),
              FontSize->16]}]}], TraditionalForm]],
    FontWeight->"Bold"],
  ". Es evidente que, para ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(f(z)\),
            FontWeight->"Bold"], 
          StyleBox["=",
            FontWeight->"Bold"], 
          RowBox[{
            StyleBox[\(z\^2\),
              FontWeight->"Bold"], 
            StyleBox["+",
              FontWeight->"Bold"], 
            StyleBox["1",
              FontWeight->"Bold"], " "}]}], TraditionalForm]]],
  "partiendo de un valor real obtenemos siempre valores reales por lo que el \
m\[EAcute]todo no puede proporcionarnos las ra\[IAcute]ces de ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(z\^2 + 1\  = 0\),
          FontWeight->"Bold"], TraditionalForm]]],
  " que son complejas. Repite con una ligera variante."
}], "Text"],

Cell[BoxData[
    \(FindRoot[z\^2 + 1 \[Equal] 0, {z, 0.5 + 0.1  \[ImaginaryI]}]\)], "Input"],

Cell[TextData[{
  "Ahora ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ha calculado la soluci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(z = \[ImaginaryI]\),
          FontWeight->"Bold"], TraditionalForm]]],
  StyleBox[" ",
    FontWeight->"Bold"],
  "con gran precisi\[OAcute]n. Observa ahora el efecto de cambiar un poco el \
valor inicial."
}], "Text"],

Cell[BoxData[
    \(FindRoot[z\^2 + 1 \[Equal] 0, {z, 0.5 - 0.1  \[ImaginaryI]}]\)], "Input"],

Cell[TextData[{
  "Como puedes ver ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " aplica el m\[EAcute]todo de Newton para calcular ra\[IAcute]ces tanto \
reales como complejas. Ahora bien, la intrepretaci\[OAcute]n del \
m\[EAcute]todo en el caso del c\[AAcute]lculo de ra\[IAcute]ces reales no \
tiene sentido en el caso complejo. En el caso real, el punto ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(z\_\(n + 1\)\),
          FontWeight->"Bold"], TraditionalForm]]],
  StyleBox[" ",
    FontWeight->"Bold"],
  "se obtiene como el punto de corte de la recta tangente a la curva ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(y = f(z)\),
          FontWeight->"Bold"], TraditionalForm]]],
  " en el punto",
  StyleBox[" ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\((z\_n, f(z\_n))\)\)],
    FontWeight->"Bold"],
  " con el eje de abscisas y se conocen condiciones precisas que garantizan \
la convergencia del m\[EAcute]todo. Lo que ocurre en el caso complejo puede \
ser ",
  StyleBox["mucho m\[AAcute]s complicado",
    FontSlant->"Italic"],
  " como vas a ver. "
}], "Text"],

Cell[CellGroupData[{

Cell["Ejercicio 6", "Exercise"],

Cell[TextData[{
  "Define una funci\[OAcute]n compilada que, partiendo de un valor inicial ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          StyleBox[\(z = x + \[ImaginaryI]\ y\),
            FontWeight->"Bold"]}], TraditionalForm]]],
  StyleBox[", ",
    FontWeight->"Bold"],
  "calcule las sucesivas iteraciones del m\[EAcute]todo de Newton para \
aproximar una soluci\[OAcute]n de ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(z\^5 + 1 = 0\),
          FontWeight->"Bold"], TraditionalForm]]],
  " y que se pare si en alg\[UAcute]n paso el valor obtenido de ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\(z\)\(\ \ \)\),
          FontWeight->"Bold"], TraditionalForm]]],
  "verifica que ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\(|\)\(z\^5 + 1\)\(|\)\(\(\[LessEqual]\)\(0.001\)\)\),
          FontWeight->"Bold"], TraditionalForm]]],
  " o si ha llegado a la iteraci\[OAcute]n n\[UAcute]mero cincuenta. Puede \
ser conveniente tomar precauciones para no dividir por cero. La salida de \
esta funci\[OAcute]n debe ser el n\[UAcute]mero de iteraciones realizadas. \
Finalmente usa  DensityPlot",
  Cell[BoxData[
      \(TraditionalForm\`\([f(x, y), \ {x, \ xmin, \ xmax}, \ {y, \ ymin, \ 
          ymax}]\)\)]],
  " para representar la funci\[OAcute]n en el intervalo [-2,2]x[-2,2] con las \
opciones apropiadas para optimizar la gr\[AAcute]fica. "
}], "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sucesiones de potencias complejas", "Section"],

Cell[TextData[{
  "Una sucesi\[OAcute]n cuyo t\[EAcute]rmino n-\[EAcute]simo viene dado en \
funci\[OAcute]n de algunos de los t\[EAcute]rminos anteriores se dice que es \
una sucesi\[OAcute]n recurrente. Ya hemos visto ejemplos de tales sucesiones \
en la lecci\[OAcute]n anterior al estudiar los conjuntos de Julia y de \
Mandelbrot. Las llamadas \"iteraciones de punto fijo\" consistentes en iterar \
una funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  " a partir de un valor inicial ",
  Cell[BoxData[
      \(TraditionalForm\`x\_1\)]],
  " para formar la sucesi\[OAcute]n dada por ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(x\_\(n + 1\)\),
            "TraditionalForm"], "=", \(g(x\_n)\)}], TraditionalForm]]],
  " son un ejemplo de sucesiones recurrentes. En esta pr\[AAcute]ctia vamos a \
estudiar sucesiones que se obtienen iterando potencias complejas. Veremos \
primero un caso particular que nos permitir\[AAcute] introducir y \
ejemplificar algunos conceptos usuales en el estudio de este tipo de \
sucesiones, y despu\[EAcute]s t\[UAcute] deber\[AAcute]s tomar la iniciativa \
y hacer los ejercicios que te propongo. En esta pr\[AAcute]ctica necesitar\
\[AAcute]s usar los comandos Nest[f,x,n] y NestList[f,x,n]. En la ayuda de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " encontrar\[AAcute]s informaci\[OAcute]n detallada sobre ellos."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "La sucesi\[OAcute]n  ",
  Cell[BoxData[
      \(TraditionalForm\`x[n + 1] = \[ImaginaryI]\^x[n]\)]],
  " con  ",
  Cell[BoxData[
      \(TraditionalForm\`x[1] = \[ImaginaryI]\)]]
}], "Section"],

Cell[BoxData[
    \(g[z_] := \(\(\(I^z\)\(\ \ \ \)\)\( (*\ 
        definimos\ la\ funci\[OAcute]n\ que\ vamos\ a\ iterar\ *) \)\(\ \
\)\)\)], "Input"],

Cell[BoxData[
    \(\(\(lista\)\(=\)\(\(N[NestList[g, I, 29]]\)\(\ \)\)\( (*\ 
        los\ primeros\ 30\ t\[EAcute]rminos\ de\ la\ sucesi\[OAcute]n\ *) \
\)\)\)], "Input"],

Cell[BoxData[
    \(\(\(puntos = Transpose[{Re[lista], Im[lista]}]\ ;\)\( (*\ 
      pasamos\ a\ coordenadas\ cartesianas\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(\(\(\(Show[Graphics[{PointSize[ .015], Point /@ puntos}], 
        Axes \[Rule] True, PlotRange \[Rule] All, 
        AspectRatio \[Rule] 1];\)\(\ \)\)\( (*\ 
      representamos\ los\ puntos\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(\(\(\(Show[
        Graphics[{Line[puntos], {PointSize[ .015], Point /@ puntos}}], 
        Axes \[Rule] True, PlotRange \[Rule] All, 
        AspectRatio \[Rule] 1];\)\(\ \)\)\( (*\ 
      unimos\ los\ puntos\ consecutivos\ con\ segmentos\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(\(colores = 
        Flatten[Table[{Hue[0], Hue[ .33], Hue[ .66]}, {k, 1, 10}]]\  (*\ 
        para\ aplicar\ colores\ a\ cada\ punto . \ 
            Procura\ entender\ la\ forma\ en\ que\ lo\ hago\ *) ;\)\)], \
"Input"],

Cell[BoxData[
    \(\(graf1 = 
        Show[Graphics[{Line[puntos], {PointSize[ .015], 
                Transpose[{colores, Point /@ puntos}]}}], Axes \[Rule] True, 
          PlotRange \[Rule] All, AspectRatio \[Rule] 1];\)\)], "Input"],

Cell["\<\
El l\[IAcute]mite de la sucesi\[OAcute]n debe ser un punto fijo de la funci\
\[OAcute]n g.\
\>", "Text"],

Cell[BoxData[
    \(\[Alpha] = \(\(z\)\(/.\)\(FindRoot[
          g[z] - z, {z, Nest[g, I, 5]}]\)\(\ \)\( (*\ 
          calculamos\ el\ l\[IAcute]mite\ de\ la\ sucesi\[OAcute]n\ *) \
\)\)\)], "Input"],

Cell[BoxData[
    \(\(\(\(g[\[Alpha]]\)\(\ \)\)\( (*\ 
      comprobamos\ que\ \[Alpha]\ es\ un\ punto\ fijo\ de\ la\ \
funci\[OAcute]n\ *) \)\)\)], "Input"],

Cell["\<\
Observa que si z est\[AAcute] cerca de \[Alpha] entonces \
g[z]-g[\[Alpha]]=g[z]-\[Alpha] es aproximadamente igual a g'[\[Alpha]](z-\
\[Alpha]). Es decir, sustituir z por g[z]  en z-\[Alpha] tiene \
aproximadamente el mismo efecto que multiplicar z-a por g'[\[Alpha]]. \
Definamos:\
\>", "Text"],

Cell[BoxData[
    \(e[n_] := \(\(N[Nest[g, I, n]]\)\(-\)\(\ \)\(\(\[Alpha]\)\(\ \)\)\( (*\ 
          trasladamos\ los\ t\[EAcute]rminos\ de\ la\ sucesi\[OAcute]n . \ 
                Observa\ que\n\t\t\  | e[n] | \ 
            es\ la\ distancia\ de\ x[
                n + 1]\ al\ l\[IAcute]mite\ *) \)\)\)], "Input"],

Cell["\<\
Para representar los puntos e[n] basta trasladar el origen en la \
gr\[AAcute]fica anterior.\
\>", "Text"],

Cell[BoxData[
    \(\(\(Show[graf1, 
        AxesOrigin \[Rule] {Re[\[Alpha]], 
            Im[\[Alpha]]}];\)\(\ \)\)\)], "Input"],

Cell[TextData[{
  "Seg\[UAcute]n lo antes dicho, tenemos que ",
  Cell[BoxData[
      \(TraditionalForm\`e[n + 1] \[TildeEqual] \(g'\)[\[Alpha]] 
            e[n] = \((\(-0.5664173302856166`\) + 
              0.6884532271076301`\ \[ImaginaryI])\) e[n]\)]],
  ". Es decir ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(e[n + 1]\)\(\ \)\)\)]],
  "se obtiene:\n1\.ba) Girando ",
  Cell[BoxData[
      \(TraditionalForm\`e[n]\)]],
  " un \[AAcute]ngulo (en grados) igual a:"
}], "Text"],

Cell[BoxData[
    \(Arg[\(g'\)[\[Alpha]]]*180/Pi\)], "Input"],

Cell[TextData[{
  "Deducimos que cada t\[EAcute]rmino est\[AAcute] girado aproximadamente \
unos 129 grados respecto del anterior (con centro de giro en \[Alpha]). Eso \
explica que la gr\[AAcute]fica aparezca como una triple espiral.\n2\.ba) \
Multiplicando el m\[OAcute]dulo de ",
  Cell[BoxData[
      \(TraditionalForm\`e[n]\)]],
  " por:"
}], "Text"],

Cell[BoxData[
    \(Abs[\(g'\)[\[Alpha]]]\)], "Input"],

Cell[TextData[{
  "Deducimos que ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(|\)\(\ \)\(e[
          n + 1]\)\(\ \)\(|\)\(\(\[TildeEqual]\)\(0.891514\)\)\(|\)\(e[
          n]\)\(|\)\)\)]],
  " esto es la distancia al l\[IAcute]mite decrece por el factor 0.891514, lo \
que nos dice que la sucesi\[OAcute]n se aproxima bastante r\[AAcute]pidamente \
a su l\[IAcute]mite. "
}], "Text"],

Cell[BoxData[
    \(Abs[e[100]]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "La sucesi\[OAcute]n  ",
  Cell[BoxData[
      \(TraditionalForm\`x[n + 1] = a\^x[n]\)]],
  " con  ",
  Cell[BoxData[
      \(TraditionalForm\`x[1] = z\)]],
  "   (a,z \[Element] \[DoubleStruckCapitalC])"
}], "Section"],

Cell[BoxData[
    \(Clear["\<Global`*\>"]\)], "Input"],

Cell[BoxData[
    \(\(\(\(potencia[a_]\)[z_]\)\(:=\)\(\(a^z\)\(\ \ \ \)\)\( (*\ 
        definimos\ la\ funci\[OAcute]n\ que\ ahora\ depende\ de\ un\ par\
\[AAcute]metro\ a \[NotEqual] 0\ *) \)\(\ \)\)\)], "Input"],

Cell[TextData[{
  "Cuando la sucesi\[OAcute]n es convergente su l\[IAcute]mite, que no \
depende del valor inicial ",
  Cell[BoxData[
      \(TraditionalForm\`x\_1\)]],
  ", viene dado por:"
}], "Text"],

Cell[BoxData[
    \(puntofijopotencia[
        a_] := \(\(z\)\(/.\)\(FindRoot[
          a^z \[Equal] z, {z, Nest[potencia[a], 1.  + 1. \ I, 4]}, \n\t
          MaxIterations \[Rule] 30]\)\(\ \)\)\)], "Input"],

Cell["\<\
Hemos visto antes que el comportamiento de la sucesi\[OAcute]n depende del n\
\[UAcute]mero:\
\>", "Text"],

Cell[BoxData[
    \(H[a_] := \(potencia[a]'\)[puntofijopotencia[a]]\)], "Input"],

Cell[TextData[{
  "Podemos elegir ",
  StyleBox["a",
    FontSlant->"Italic"],
  " para conseguir un comportamiento determinado aunque hay que tener en \
cuenta que, si bien el posible l\[IAcute]mite de la sucesi\[OAcute]n \
solamente depende del valor de ",
  StyleBox["a",
    FontSlant->"Italic"],
  ", la convergencia puede depender del valor inicial. Si  ",
  Cell[BoxData[
      \(TraditionalForm\`Abs[H[a]] < 1\)]],
  " y elegimos x[1] pr\[OAcute]ximo a ",
  StyleBox["puntofijopotenccia[a]",
    FontSlant->"Italic"],
  " entonces la sucesi\[OAcute]n converge a dicho n\[UAcute]mero el cual se \
dice que es un punto fijo ",
  StyleBox["atractivo",
    FontSlant->"Italic"],
  ". Si  ",
  Cell[BoxData[
      \(TraditionalForm\`Abs[H[a]] > 1\)]],
  " y elegimos x[1] pr\[OAcute]ximo a ",
  StyleBox["puntofijopotencia[a] ",
    FontSlant->"Italic"],
  "pero distinto de ",
  StyleBox["puntofijopotencia[a]",
    FontSlant->"Italic"],
  " entonces la sucesi\[OAcute]n no converge. En este caso se dice que ",
  StyleBox["puntofijopotencia[a] ",
    FontSlant->"Italic"],
  "es un punto fijo ",
  StyleBox["repelente",
    FontSlant->"Italic"],
  ". Hasta aqu\[IAcute] llego yo y ahora debes seguir t\[UAcute]."
}], "Text"],

Cell[CellGroupData[{

Cell["Ejercicio 7", "Exercise"],

Cell[TextData[{
  StyleBox["1",
    FontWeight->"Bold"],
  " Define una funci\[OAcute]n gr\[AAcute]fica, \"puntossucesion[a_, z_, n_, \
opts___]\",  que al ejecutarla muestre en pantalla los primeros n \
t\[EAcute]rminos de la sucesi\[OAcute]n  x[n+1]=a^x[n] con x[1]=z como puntos \
del plano unidos por segmentos. Elige un tama\[NTilde]o adecuado para los \
puntos y representa cada tres puntos consecutivos en colores rojo, verde y \
azul como hemos hecho antes. Centra el origen de coordenadas en el posible l\
\[IAcute]mite de la sucesi\[OAcute]n y p\[AAcute]sale las opciones \
gr\[AAcute]ficas a la funci\[OAcute]n que defines. \nSugerencias. Puede ser \
\[UAcute]til que primero definas una lista \"puntos[a_,z_,n_]\" a la que \
puedas aplicar las primitivas gr\[AAcute]ficas Point y Line."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 8", "Exercise"],

Cell[TextData[{
  StyleBox["a)",
    FontWeight->"Bold"],
  " Considera la siguiente lista de n\[UAcute]meros complejos. "
}], "Text"],

Cell[BoxData[
    \(\(valoresa = 
        Flatten[Table[
            x\  + \ y\ I, {x, 0. , 3, 0.25}, {y,  .5, 2.5, 
              0.25}]];\)\)], "Input"],

Cell[TextData[{
  "Construye a partir de ella una lista, \"puntosfijovaloresa\", cuyos \
elementos sean listas de la forma \n\t\t\t\t{a, puntofijopotencia[a], \
Abs[H[a]], Arg[H[a]]*180/N[\[Pi]]} \ndonde a\[Element]valoresa. \n\
Sugerencias. Todo lo que tienes que hacer es \"lanzar\" una funci\[OAcute]n, \
es f\[AAcute]cil imaginar cu\[AAcute]l, para que act\[UAcute]e sobre los \
elementos de la lista \"valoresa\". Recuerda el uso de #  y & para sustituir \
las variables as\[IAcute] como el comando /@.\n",
  StyleBox["b) ",
    FontWeight->"Bold"],
  "Selecciona los elementos de la lista \"puntosfijovaloresa\" para los que \
se verifica que Abs[H[a]]<.5. Estos valores de a son puntos fijos atractivos. \
Elije uno de ellos y un valor de z m\[AAcute]s o menos pr\[OAcute]ximo a \
\[EAcute]l para representar con el comando \"puntossucesion[a_, z_, n_, \
opts___]\"  los primeros 9 t\[EAcute]rminos de la sucesi\[OAcute]n \
correspondiente.\nSugerencia. Usa el comando \"Select[lista,cri",
  StyleBox["teriodeseleccion]\" (consulta si es necesario la ayuda).",
    InitializationCell->True],
  "\nc",
  StyleBox[") ",
    FontWeight->"Bold"],
  "Selecciona los elementos de la lista \"puntosfijovaloresa\" para los que \
se verifica que Abs[H[a]]>1.3. Estos valores de a son puntos fijos \
repelentes. Elije uno de ellos y un valor de z m\[AAcute]s o menos \
pr\[OAcute]ximo a \[EAcute]l para representar con el comando \
\"puntossucesion[a_, z_, n_, opts___]\"  los primeros 9 t\[EAcute]rminos de \
la sucesi\[OAcute]n correspondiente.\n",
  StyleBox["d)",
    FontWeight->"Bold"],
  " Hemos visto que ",
  Cell[BoxData[
      \(TraditionalForm\`Arg[H[a]]\)]],
  " indica el \[AAcute]ngulo (en radianes) que cada t\[EAcute]rmino de la \
sucesi\[OAcute]n est\[AAcute] girado respecto del t\[EAcute]rmino anterior \
(con centro de giro en ",
  StyleBox["puntofijopotencia[a]",
    FontSlant->"Italic"],
  "). Selecciona los elementos de la lista \"puntosfijovaloresa\" para los \
que se verifica que 118<Arg[H[a]]<122. Elige dos de ellos, uno que sea un \
punto fijo atractivo y otro que sea un punto fijo repelente y elige valores \
adecuados de z para representar en cada caso los primeros 30 t\[EAcute]rminos \
de la sucesi\[OAcute]n correspondiente."
}], "Text"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowSize->{1016, 635},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ 
        "N\[UAcute]meros complejos. Visualizaci\[OAcute]n de funciones \
complejas"], "Header"]}, {Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ 
        "N\[UAcute]meros complejos. Visualizaci\[OAcute]n de funciones \
complejas"], "Header"]}},
PrintingOptions->{"FirstPageHeader"->False,
"FacingPages"->True},
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 145, 3, 249, "Title"],
Cell[1902, 56, 199, 4, 102, "Author"],

Cell[CellGroupData[{
Cell[2126, 64, 61, 0, 93, "Section"],
Cell[2190, 66, 861, 16, 171, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3088, 87, 111, 3, 93, "Section"],
Cell[3202, 92, 480, 10, 93, "Text"],
Cell[3685, 104, 343, 13, 228, "Input"],
Cell[4031, 119, 225, 5, 67, "Text"],
Cell[4259, 126, 496, 11, 93, "Text"],
Cell[4758, 139, 131, 3, 124, "Input"],
Cell[4892, 144, 773, 27, 70, "Text"],
Cell[5668, 173, 520, 15, 150, "Input"],
Cell[6191, 190, 355, 9, 67, "Text"],
Cell[6549, 201, 1101, 21, 358, "Input"],
Cell[7653, 224, 459, 10, 93, "Text"],
Cell[8115, 236, 1015, 20, 358, "Input"],
Cell[9133, 258, 248, 8, 41, "Text"],
Cell[9384, 268, 275, 5, 67, "Text"],
Cell[9662, 275, 210, 3, 231, "Input"],
Cell[9875, 280, 721, 16, 120, "Text"],
Cell[10599, 298, 72, 1, 72, "Input"],
Cell[10674, 301, 1580, 53, 153, "Text"],
Cell[12257, 356, 90, 2, 117, "Input"],
Cell[12350, 360, 949, 20, 145, "Text"],
Cell[13302, 382, 179, 3, 112, "Input"],
Cell[13484, 387, 359, 7, 166, "Input"],
Cell[13846, 396, 171, 3, 85, "Input"],
Cell[14020, 401, 224, 3, 137, "Input"],
Cell[14247, 406, 211, 4, 109, "Input"],
Cell[14461, 412, 295, 7, 67, "Text"],
Cell[14759, 421, 148, 5, 41, "Text"],
Cell[14910, 428, 65, 1, 72, "Input"],
Cell[14978, 431, 262, 7, 67, "Text"],
Cell[15243, 440, 229, 5, 124, "Input"],
Cell[15475, 447, 47, 0, 41, "Text"],
Cell[15525, 449, 70, 1, 72, "Input"],
Cell[15598, 452, 618, 17, 93, "Text"],
Cell[16219, 471, 358, 6, 196, "Input"],
Cell[16580, 479, 106, 3, 41, "Text"],
Cell[16689, 484, 85, 1, 72, "Input"],
Cell[16777, 487, 275, 6, 62, "Text"],
Cell[17055, 495, 89, 1, 72, "Input"],
Cell[17147, 498, 203, 8, 41, "Text"],
Cell[17353, 508, 250, 4, 124, "Input"],
Cell[17606, 514, 54, 1, 72, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17697, 520, 63, 0, 93, "Section"],
Cell[17763, 522, 728, 17, 93, "Text"],
Cell[18494, 541, 654, 18, 98, "Text"],
Cell[19151, 561, 1580, 30, 800, "Input"],
Cell[20734, 593, 274, 6, 67, "Text"],
Cell[21011, 601, 56, 1, 72, "Input"],
Cell[21070, 604, 125, 3, 41, "Text"],
Cell[21198, 609, 313, 5, 150, "Input"],
Cell[21514, 616, 52, 1, 72, "Input"],
Cell[21569, 619, 320, 6, 67, "Text"],
Cell[21892, 627, 882, 18, 332, "Input"],
Cell[22777, 647, 39, 0, 41, "Text"],
Cell[22819, 649, 65, 1, 72, "Input"],
Cell[22887, 652, 432, 11, 93, "Text"],
Cell[23322, 665, 627, 9, 119, "Text"],
Cell[23952, 676, 1063, 19, 384, "Input"],
Cell[25018, 697, 277, 6, 67, "Text"],
Cell[25298, 705, 46, 1, 72, "Input"],
Cell[25347, 708, 120, 2, 72, "Input"],
Cell[25470, 712, 402, 9, 74, "Text"],
Cell[25875, 723, 646, 12, 228, "Input"],

Cell[CellGroupData[{
Cell[26546, 739, 88, 4, 68, "Exercise"],
Cell[26637, 745, 1530, 25, 351, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[28204, 775, 88, 4, 68, "Exercise"],
Cell[28295, 781, 158, 3, 41, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[28490, 789, 88, 4, 68, "Exercise"],
Cell[28581, 795, 281, 5, 67, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[28899, 805, 88, 4, 68, "Exercise"],
Cell[28990, 811, 374, 9, 67, "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[29413, 826, 38, 0, 93, "Section"],
Cell[29454, 828, 1057, 15, 197, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[30548, 848, 37, 0, 93, "Section"],
Cell[30588, 850, 2001, 44, 301, "Text"],
Cell[32592, 896, 340, 7, 67, "Text"],
Cell[32935, 905, 398, 7, 176, "Input"],
Cell[33336, 914, 55, 1, 72, "Input"],
Cell[33394, 917, 753, 12, 145, "Text"],
Cell[34150, 931, 669, 13, 254, "Input"],
Cell[34822, 946, 623, 13, 119, "Text"],
Cell[35448, 961, 456, 10, 176, "Input"],
Cell[35907, 973, 121, 2, 98, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[36065, 980, 57, 0, 93, "Section"],
Cell[36125, 982, 5701, 183, 358, "Text"],

Cell[CellGroupData[{
Cell[41851, 1169, 31, 0, 68, "Exercise"],
Cell[41885, 1171, 2928, 88, 327, "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[44862, 1265, 101, 1, 93, "Section"],
Cell[44966, 1268, 1725, 49, 197, "Text"],
Cell[46694, 1319, 72, 1, 73, "Input"],
Cell[46769, 1322, 1203, 33, 107, "Text"],
Cell[47975, 1357, 93, 1, 73, "Input"],
Cell[48071, 1360, 389, 13, 41, "Text"],
Cell[48463, 1375, 93, 1, 73, "Input"],
Cell[48559, 1378, 1130, 31, 145, "Text"],

Cell[CellGroupData[{
Cell[49714, 1413, 31, 0, 68, "Exercise"],
Cell[49748, 1415, 1413, 34, 171, "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[51210, 1455, 52, 0, 93, "Section"],
Cell[51265, 1457, 1425, 28, 223, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[52727, 1490, 212, 7, 93, "Section"],
Cell[52942, 1499, 151, 3, 72, "Input"],
Cell[53096, 1504, 172, 3, 72, "Input"],
Cell[53271, 1509, 143, 2, 98, "Input"],
Cell[53417, 1513, 233, 4, 124, "Input"],
Cell[53653, 1519, 281, 5, 124, "Input"],
Cell[53937, 1526, 241, 5, 124, "Input"],
Cell[54181, 1533, 237, 4, 176, "Input"],
Cell[54421, 1539, 114, 3, 41, "Text"],
Cell[54538, 1544, 201, 4, 98, "Input"],
Cell[54742, 1550, 157, 3, 72, "Input"],
Cell[54902, 1555, 305, 6, 67, "Text"],
Cell[55210, 1563, 319, 5, 124, "Input"],
Cell[55532, 1570, 116, 3, 41, "Text"],
Cell[55651, 1575, 130, 3, 72, "Input"],
Cell[55784, 1580, 484, 13, 79, "Text"],
Cell[56271, 1595, 61, 1, 72, "Input"],
Cell[56335, 1598, 355, 8, 105, "Text"],
Cell[56693, 1608, 54, 1, 72, "Input"],
Cell[56750, 1611, 388, 9, 67, "Text"],
Cell[57141, 1622, 44, 1, 72, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[57222, 1628, 237, 8, 93, "Section"],
Cell[57462, 1638, 54, 1, 72, "Input"],
Cell[57519, 1641, 214, 3, 98, "Input"],
Cell[57736, 1646, 202, 6, 41, "Text"],
Cell[57941, 1654, 209, 4, 124, "Input"],
Cell[58153, 1660, 116, 3, 41, "Text"],
Cell[58272, 1665, 80, 1, 72, "Input"],
Cell[58355, 1668, 1229, 35, 145, "Text"],

Cell[CellGroupData[{
Cell[59609, 1707, 31, 0, 68, "Exercise"],
Cell[59643, 1709, 810, 13, 183, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[60490, 1727, 31, 0, 68, "Exercise"],
Cell[60524, 1729, 134, 4, 41, "Text"],
Cell[60661, 1735, 154, 4, 72, "Input"],
Cell[60818, 1741, 2272, 42, 515, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

